// Rocko's AOE Dragon.
using System;
using Server;
using Server.Items;
using Xanthos.Evo;

namespace Server.Mobiles
{
    //[CorpseName("a fire dragon corpse")]
    public class FireDragon : BaseCreature
    {
        public override WeaponAbility GetWeaponAbility()
        {
            return Utility.RandomBool() ? WeaponAbility.ConcussionBlow : WeaponAbility.CrushingBlow;
        }

        [Constructable]
        public FireDragon()
            : base(AIType.AI_Mage, FightMode.Closest, 10, 1, 0.2, 0.4)
        {
            Name = "a fire dragon";
            Body = 59;
            BaseSoundID = 362;
            Hue = 1161;

            SetStr(796, 825);
            SetDex(106, 300);
            SetInt(1000, 1575);

            SetHits(3000, 3500);
            SetStam(100, 600);

            SetDamage(20, 26);

            SetDamageType(ResistanceType.Fire, 60);
            SetDamageType(ResistanceType.Physical, 40);

            SetResistance(ResistanceType.Physical, 60, 75);
            SetResistance(ResistanceType.Fire, 100);
            SetResistance(ResistanceType.Cold, 60);
            SetResistance(ResistanceType.Poison, 60, 75);
            SetResistance(ResistanceType.Energy, 60, 75);

            SetSkill(SkillName.EvalInt, 190.0, 220.0);
            SetSkill(SkillName.Magery, 190.0, 220.0);
            SetSkill(SkillName.Meditation, 52.5, 75.0);
            SetSkill(SkillName.MagicResist, 100.5, 150.0);
            SetSkill(SkillName.Tactics, 97.6, 100.0);
            SetSkill(SkillName.Wrestling, 97.6, 100.0);

            Fame = 25000;
            Karma = -25000;

            VirtualArmor = 70;
            Tamable = false;
            AddItem(new LightSource());

            PackItem(new RaelisDragonDust(Utility.RandomMinMax(5, 30)));
            PackItem(new Tokens(Utility.RandomMinMax(5, 15)));
        }
        
        public override void OnDeath( Container c )
        {
        	base.OnDeath( c );			
        	PackRunicTool( c, 0.05, typeof( RunicDr ) );
        }

        public override void GenerateLoot()
        {
            AddLoot(LootPack.UltraRich, 3);
            AddLoot(LootPack.Gems, 8);
        }

        public override void AlterSpellDamageFrom(Mobile from, ref int damage)
        {
            damage /= 2;
        }

        public override bool BardImmune { get { return true; } }
        public override bool Unprovokable { get { return true; } }
        public override bool Uncalmable { get { return true; } }
        public override Poison PoisonImmune { get { return Poison.Greater; } }

        public override int BreathFireDamage { get { return 100; } }
        public override double BreathDamageScalar { get { return 0.10; } }

        public override bool HasAOEBreath { get { return true; } }
        public override string AOEBreathName { get { return "inferno"; } }
        public override int AOEBreathRadius { get { return 4; } }
        public override int AOEBreathDuration { get { return 2; } }
        public override int AOEBreathEffectItemID { get { return 0x3709; } }
        public override int AOEBreathEffectHue { get { return 0; } }

        public override bool ReacquireOnMovement { get { return true; } }
        public override bool HasBreath { get { return true; } } // fire breath enabled
        public override bool AutoDispel { get { return true; } }
        public override int TreasureMapLevel { get { return 5; } }
        public override int Meat { get { return 25; } }
        public override int Hides { get { return 15; } }
        public override HideType HideType { get { return HideType.Dragon; } }
        public override int Scales { get { return 5; } }
        public override ScaleType ScaleType { get { return ScaleType.Red; } }
        public override bool IsNotScaredOfDeath { get { return true; } } //neutika pri malem poctu hp

        public FireDragon(Serial serial)
            : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);
            writer.Write((int)0);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);
            int version = reader.ReadInt();
        }
    }
}